/*
 * Decompiled with CFR 0.152.
 */
package webdlpindexer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.Socket;
import java.util.UUID;
import webdlpindexer.Logger;
import webdlpindexer.indexer.IndexerHandler;
import webdlpindexer.indexer.indexrequest.ClientIndexRequest;

public class ClientHandler
implements Runnable {
    private Socket clientSocket;
    private IndexerHandler handler;

    public ClientHandler(IndexerHandler h, Socket socket) {
        this.clientSocket = socket;
        this.handler = h;
    }

    @Override
    public void run() {
        try {
            ObjectInputStream input = new ObjectInputStream(this.clientSocket.getInputStream());
            String data = input.readUTF();
            File f = new File("tmp" + System.getProperty("file.separator") + UUID.randomUUID().toString() + ".tmp");
            f.createNewFile();
            BufferedWriter bf = new BufferedWriter(new FileWriter(f));
            bf.write(data);
            bf.flush();
            bf.close();
            int threshold = input.readInt();
            ClientIndexRequest.RequestType t = threshold >= 0 && threshold <= 100 ? ClientIndexRequest.RequestType.TEST_SIMILARITY_WITH_THRESHOLD : ClientIndexRequest.RequestType.TEST_SIMILARITY;
            ClientIndexRequest request = new ClientIndexRequest(t, f, threshold, this.clientSocket);
            this.handler.submitIndexRequest(request);
        }
        catch (IOException ex) {
            Logger.exception(ex);
        }
    }
}

