/*
 * Decompiled with CFR 0.152.
 */
package webdlpindexer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.net.InetAddress;
import java.util.Date;

public class Logger {
    public static boolean logToConsole = false;
    public static File logFile;
    public static final String hostName;

    public static void log(String s) {
        s = "[INFO] (" + (hostName.equals("") ? "" : hostName + ", ") + new Date().toString() + "): " + s;
        if (logToConsole) {
            System.out.println(s);
        }
        Logger.updateLogFile(s);
    }

    public static void warn(String s) {
        s = "[WARN] (" + (hostName.equals("") ? "" : hostName + ", ") + new Date().toString() + "): " + s;
        if (logToConsole) {
            System.out.println(s);
        }
        Logger.updateLogFile(s);
    }

    public static void error(String s) {
        s = "[ERROR] (" + (hostName.equals("") ? "" : hostName + ", ") + new Date().toString() + "): " + s;
        if (logToConsole) {
            System.err.println(s);
        }
        Logger.updateLogFile(s);
    }

    public static void exception(Exception ex) {
        Logger.exception(ex, null);
    }

    public static void exception(Exception ex, String message) {
        if (logToConsole) {
            StringBuilder s = new StringBuilder();
            for (StackTraceElement ste : ex.getStackTrace()) {
                s.append(ste.toString());
                s.append(System.getProperty("line.separator"));
            }
            if (message == null || message.isEmpty()) {
                Logger.error("An unexpected exception was encountered: ");
            } else {
                Logger.error(message);
            }
            Logger.error(s.toString());
        }
    }

    public static void updateLogFile(String s) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(logFile, true));
            writer.write(System.getProperty("line.separator"));
            writer.write(s);
            writer.flush();
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        InetAddress localHost = null;
        try {
            localHost = InetAddress.getLocalHost();
        }
        catch (Exception exception) {
            // empty catch block
        }
        hostName = localHost != null ? localHost.getHostName() : "";
    }
}

