/*
 * Decompiled with CFR 0.152.
 */
package webdlpindexer;

import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.io.FileUtils;
import webdlpindexer.ClientHandler;
import webdlpindexer.Logger;
import webdlpindexer.indexer.IndexerHandler;

public class Server
implements Runnable {
    private File indexDir;
    private File intellectualPropertyDir;
    private boolean newIndex;
    private boolean keepDelFiles;
    private boolean debug;
    private int portNum;
    private ServerSocket socket;
    IndexerHandler handler;

    public Server(File indexDir, File intellectualPropertyDir, boolean newIndex, boolean keepDelFiles, boolean debug, int portNum) {
        this.indexDir = indexDir;
        this.intellectualPropertyDir = intellectualPropertyDir;
        this.newIndex = newIndex;
        this.keepDelFiles = keepDelFiles;
        this.debug = debug;
        this.portNum = portNum;
        File tmpDir = new File("tmp");
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        } else {
            try {
                FileUtils.cleanDirectory(tmpDir);
            }
            catch (IOException ex) {
                Logger.exception(ex);
            }
        }
    }

    @Override
    public void run() {
        try {
            InetSocketAddress socketAddress = new InetSocketAddress(this.portNum);
            this.socket = new ServerSocket();
            this.socket.bind(socketAddress);
        }
        catch (BindException ex) {
            System.out.println("Error: Something is already running on port " + this.portNum + "!");
            System.out.println("Is another instance of the WebDLPIndexer running?");
            System.out.println("Exiting...");
            System.exit(1);
        }
        catch (IOException ex) {
            Logger.exception(ex);
        }
        this.handler = new IndexerHandler(this.indexDir, this.intellectualPropertyDir, this.newIndex, this.keepDelFiles, this.debug);
        Thread t = new Thread(this.handler);
        t.start();
        while (true) {
            try {
                while (true) {
                    Socket clientSocket = this.socket.accept();
                    ClientHandler clientHandler = new ClientHandler(this.handler, clientSocket);
                    Thread clientHandlerThread = new Thread(clientHandler);
                    clientHandlerThread.start();
                }
            }
            catch (IOException ex) {
                Logger.exception(ex);
                continue;
            }
            break;
        }
    }
}

