/*
 * Decompiled with CFR 0.152.
 */
package webdlpindexer;

import java.io.File;
import webdlpindexer.Logger;
import webdlpindexer.Server;

public class WebDLPIndexer {
    public static final int DEFAULT_PORT = 22345;

    public static void main(String[] args) {
        String logDirName = "log";
        File logDir = new File(logDirName);
        if (!logDir.exists()) {
            logDir.mkdirs();
        }
        Logger.logFile = new File(logDirName + System.getProperty("file.separator") + "WebDLPIndexer.log");
        File indexDir = null;
        File intellectualPropertyDir = null;
        boolean newIndex = false;
        boolean keepDelFiles = false;
        boolean debug = false;
        int portNum = 22345;
        if (args.length >= 2) {
            indexDir = new File(args[0]);
            intellectualPropertyDir = new File(args[1]);
            String errorMessage = "";
            if (!indexDir.exists()) {
                errorMessage = errorMessage + "ERROR: Cannot find directory " + indexDir.toString() + "\n";
            }
            if (!intellectualPropertyDir.exists()) {
                errorMessage = errorMessage + "ERROR: Cannot find directory " + intellectualPropertyDir.toString() + "\n";
            }
            if (!indexDir.exists() || !intellectualPropertyDir.exists()) {
                Logger.error(errorMessage);
                System.out.println(errorMessage);
                System.out.println("Exiting...");
                System.exit(0);
            }
        } else {
            WebDLPIndexer.printHelp();
            System.out.println("Exiting...");
            System.exit(0);
        }
        for (int i = 2; i < args.length; ++i) {
            String errorMessage;
            if (args[i].equals("--createIndex")) {
                newIndex = true;
                continue;
            }
            if (args[i].equals("--indexDeletedFiles")) {
                keepDelFiles = true;
                continue;
            }
            if (args[i].equals("--debug")) {
                debug = true;
                continue;
            }
            if (args[i].equals("--port")) {
                if (args[i + 1] != null) {
                    ++i;
                    try {
                        portNum = Integer.parseInt(args[i]);
                    }
                    catch (NumberFormatException ex) {
                        String errorMessage2 = "ERROR: " + args[i] + " does not appear to be a valid integer.\n" + "Exiting...";
                        System.out.println(errorMessage2);
                        Logger.error(errorMessage2);
                        System.exit(0);
                    }
                    continue;
                }
                errorMessage = "ERROR: No port number specified after flag '--port'\nExiting...";
                System.out.println(errorMessage);
                Logger.error(errorMessage);
                System.exit(0);
                continue;
            }
            errorMessage = "ERROR: Unknown argument '" + args[i] + "'\n";
            Logger.error(errorMessage);
            System.out.println(errorMessage);
            WebDLPIndexer.printHelp();
            System.exit(0);
        }
        if (debug) {
            System.out.println("Intellectual Property directory : " + intellectualPropertyDir);
            System.out.println("Index directory:                : " + indexDir);
            System.out.println("Create new index upon startup   : " + newIndex);
            System.out.println("Keep deleted files in index     : " + keepDelFiles);
            System.out.println("Debug Mode                      : " + debug);
            System.out.println("Port                            : " + portNum);
        }
        Server server = new Server(indexDir, intellectualPropertyDir, newIndex, keepDelFiles, debug, portNum);
        Thread t = new Thread(server);
        t.start();
    }

    private static void printHelp() {
        System.out.println("The following arguments are required:");
        System.out.println("  arg 1: Path of intellectual property directory");
        System.out.println("  arg 2: Path of existing or desired index directory");
        System.out.println("  arg 3: (true/false) Whether or not the index should be built from scratch");
        System.out.println("  arg 4: (true/false) Whether or not deleted intellectual property files should be kept in the index");
        System.out.println("  arg 5: (true/false) Enable debug mode");
        System.out.println("  (optional) arg 6 : TCP port number for server");
        System.out.println("");
    }
}

