/*
 * Decompiled with CFR 0.152.
 */
package webdlpindexer.indexer;

import java.util.Map;
import org.apache.commons.math3.linear.OpenMapRealVector;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.RealVectorFormat;
import org.apache.commons.math3.linear.SparseRealVector;

public class DocVector {
    public Map<String, Integer> terms;
    public SparseRealVector vector;

    public DocVector(Map<String, Integer> terms) {
        this.terms = terms;
        this.vector = new OpenMapRealVector(terms.size());
    }

    public void setEntry(String term, int freq) {
        if (this.terms.containsKey(term)) {
            int pos = this.terms.get(term);
            this.vector.setEntry(pos, (double)freq);
        }
    }

    public void normalize() {
        double sum = this.vector.getL1Norm();
        this.vector = (SparseRealVector)this.vector.mapDivide(sum);
    }

    public String toString() {
        RealVectorFormat formatter = new RealVectorFormat();
        return formatter.format((RealVector)this.vector);
    }
}

