/*
 * Decompiled with CFR 0.152.
 */
package webdlpindexer.indexer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.math3.linear.RealVector;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.Version;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import webdlpindexer.Logger;
import webdlpindexer.indexer.DocVector;

public class Indexer {
    public static final String FILE_PATH = "path";
    public static final String FILE_CONTENTS = "contents";
    private File indexDir;
    private File intellectualPropertyDir;
    private boolean keepDelFiles;
    private boolean debug;
    private Directory index;
    private IndexWriter writer;
    private IndexReader reader;
    private Analyzer analyzer;
    private IndexWriterConfig config;
    private HashMap<String, DocVector> docVectors;

    public Indexer(File indexDir) {
        this(indexDir, new File("property"));
    }

    public Indexer(String indexDirPath) {
        this(new File(indexDirPath));
    }

    public Indexer(String indexDirPath, String intellectualPropertyDirPath) {
        this(new File(indexDirPath), new File(intellectualPropertyDirPath));
    }

    public Indexer(File indexDir, File intellectualPropertyDir) {
        this(indexDir, intellectualPropertyDir, false, false);
    }

    public Indexer(File indexDir, File intellectualPropertyDir, boolean keepDelFiles, boolean debug) {
        this.indexDir = indexDir;
        this.intellectualPropertyDir = intellectualPropertyDir;
        this.keepDelFiles = keepDelFiles;
        this.debug = debug;
        this.analyzer = new StandardAnalyzer(Version.LUCENE_36);
    }

    public boolean indexAll() {
        boolean success = true;
        try {
            FileUtils.cleanDirectory(this.indexDir);
        }
        catch (IOException ex) {
            Logger.exception(ex);
        }
        this.prepWriter();
        for (File f : this.intellectualPropertyDir.listFiles()) {
            if (this.indexDocument(f)) continue;
            success = false;
        }
        this.closeWriter();
        return success;
    }

    public boolean indexDocument(File f) {
        boolean result = true;
        if (f.isDirectory()) {
            for (File childFile : f.listFiles()) {
                if (this.indexDocument(childFile)) continue;
                result = false;
            }
        } else if (!this.indexFile(f)) {
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean indexFile(File f) {
        boolean singleUseWriter;
        boolean success = true;
        boolean bl = singleUseWriter = this.writer == null;
        if (singleUseWriter) {
            this.prepWriter();
        }
        FileInputStream input = null;
        try {
            File file = new File(f.getAbsolutePath());
            input = new FileInputStream(file);
            BodyContentHandler contenthandler = new BodyContentHandler(-1);
            Metadata metadata = new Metadata();
            metadata.set("resourceName", f.getAbsolutePath());
            AutoDetectParser parser = new AutoDetectParser();
            ParseContext context = new ParseContext();
            context.set(Parser.class, (Object)parser);
            try {
                parser.parse((InputStream)input, (ContentHandler)contenthandler, metadata, context);
                Document doc = new Document();
                doc.add(new Field(FILE_PATH, f.getAbsolutePath(), Field.Store.YES, Field.Index.NOT_ANALYZED));
                doc.add(new Field(FILE_CONTENTS, contenthandler.toString(), Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.WITH_POSITIONS_OFFSETS));
                this.writer.addDocument(doc);
            }
            catch (SAXException ex) {
                Logger.exception(ex);
                success = false;
            }
            catch (TikaException ex) {
                Logger.exception((Exception)((Object)ex));
                success = false;
            }
        }
        catch (FileNotFoundException ex) {
            success = false;
            Logger.exception(ex);
        }
        catch (CorruptIndexException ex) {
            success = false;
            Logger.exception(ex);
        }
        catch (LockObtainFailedException ex) {
            Logger.exception(ex);
            success = false;
        }
        catch (IOException ex) {
            Logger.exception(ex);
            success = false;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                Logger.exception(ex);
            }
            if (singleUseWriter) {
                this.closeWriter();
            }
        }
        return success;
    }

    public void removeDocument(File f) {
        if (!this.keepDelFiles) {
            this.forceRemoveDocument(f);
        }
    }

    public void forceRemoveDocument(File f) {
        this.prepWriter();
        try {
            this.writer.deleteDocuments(new Term(FILE_PATH, f.getAbsolutePath()));
        }
        catch (CorruptIndexException ex) {
            Logger.exception(ex);
        }
        catch (IOException ex) {
            Logger.exception(ex);
        }
        this.closeWriter();
    }

    public void modifyDocument(File f) {
        boolean tempDisable_keepDelFiles = false;
        if (this.keepDelFiles) {
            tempDisable_keepDelFiles = true;
            this.keepDelFiles = false;
        }
        this.removeDocument(f);
        if (tempDisable_keepDelFiles) {
            this.keepDelFiles = true;
        }
        this.indexDocument(f);
    }

    public String getIndexInfo() {
        String message = "The index at " + this.indexDir.getAbsolutePath() + " contains the following documents: \n";
        this.prepReader();
        try {
            for (int i = 0; i < this.reader.maxDoc(); ++i) {
                String filename = this.reader.document(i).get(FILE_PATH);
                int path = filename.lastIndexOf("/");
                filename = filename.substring(path + 1);
                message = message + filename + ", ";
            }
        }
        catch (IOException ex) {
            Logger.exception(ex);
        }
        message = message + "\n";
        this.closeReader();
        return message;
    }

    private void prepWriter() {
        try {
            this.index = FSDirectory.open(this.indexDir);
            this.config = new IndexWriterConfig(Version.LUCENE_36, this.analyzer);
            this.writer = new IndexWriter(this.index, this.config);
        }
        catch (IOException ex) {
            Logger.exception(ex);
        }
    }

    private void prepReader() {
        try {
            this.reader = IndexReader.open(FSDirectory.open(this.indexDir));
        }
        catch (IOException ex) {
            Logger.exception(ex);
        }
    }

    private void closeWriter() {
        try {
            this.writer.close();
            this.index.close();
            this.writer = null;
            this.index = null;
        }
        catch (CorruptIndexException ex) {
            Logger.exception(ex);
        }
        catch (IOException ex) {
            Logger.exception(ex);
        }
    }

    private void closeReader() {
        try {
            this.reader.close();
            this.reader = null;
        }
        catch (IOException ex) {
            Logger.exception(ex);
        }
    }

    public HashMap<String, Double> testSimilarity(File file) {
        this.indexDocument(file);
        this.updateDocVectors();
        int docId = this.findDocumentId(file);
        this.prepReader();
        if (docId == -1) {
            Logger.error("File " + file.getName() + " was not found in the index");
            return null;
        }
        DocVector vector = this.docVectors.get(file.getAbsolutePath());
        HashMap<String, Double> resultsMap = new HashMap<String, Double>();
        for (Map.Entry<String, DocVector> pairs : this.docVectors.entrySet()) {
            if (pairs.getKey().equals(file.getAbsolutePath())) continue;
            double cosim = this.getCosineSimilarity(vector, pairs.getValue());
            if (Double.isNaN(cosim)) {
                cosim = 0.0;
            }
            resultsMap.put(pairs.getKey(), cosim);
        }
        this.closeReader();
        return resultsMap;
    }

    public HashMap<String, Double> testSimilarityWithThreshold(File file, int threshold) {
        double thresh = (double)threshold / 100.0;
        HashMap<String, Double> map = this.testSimilarity(file);
        Iterator<Map.Entry<String, Double>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Double> pairs = iterator.next();
            if (!(pairs.getValue() < thresh)) continue;
            iterator.remove();
        }
        return map;
    }

    private double getCosineSimilarity(DocVector d1, DocVector d2) {
        return d1.vector.dotProduct((RealVector)d2.vector) / (d1.vector.getNorm() * d2.vector.getNorm());
    }

    private void updateDocVectors() {
        this.docVectors = new HashMap();
        try {
            Term term;
            this.prepReader();
            HashMap<String, Integer> terms = new HashMap<String, Integer>();
            TermEnum termEnum = this.reader.terms(new Term(FILE_CONTENTS));
            int pos = 0;
            while (termEnum.next() && FILE_CONTENTS.equals((term = termEnum.term()).field())) {
                terms.put(term.text(), pos++);
            }
            for (int i = 0; i < this.reader.maxDoc(); ++i) {
                TermFreqVector[] tfvs = this.reader.getTermFreqVectors(i);
                DocVector vector = new DocVector(terms);
                if (tfvs != null) {
                    for (TermFreqVector tfv : tfvs) {
                        String[] termTexts = tfv.getTerms();
                        int[] termFreqs = tfv.getTermFrequencies();
                        for (int j = 0; j < termTexts.length; ++j) {
                            vector.setEntry(termTexts[j], termFreqs[j]);
                        }
                    }
                }
                vector.normalize();
                this.docVectors.put(this.reader.document(i).get(FILE_PATH).toString(), vector);
            }
        }
        catch (IOException ex) {
            Logger.exception(ex);
        }
        this.closeReader();
    }

    private int findDocumentId(File f) {
        this.prepReader();
        try {
            for (int i = 0; i < this.reader.maxDoc(); ++i) {
                if (!this.reader.document(i).get(FILE_PATH).equals(f.getAbsolutePath())) continue;
                return i;
            }
        }
        catch (CorruptIndexException ex) {
            Logger.exception(ex);
        }
        catch (IOException ex) {
            Logger.exception(ex);
        }
        this.closeReader();
        return -1;
    }
}

