/*
 * Decompiled with CFR 0.152.
 */
package webdlpindexer.indexer;

import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import webdlpindexer.Logger;
import webdlpindexer.indexer.Indexer;
import webdlpindexer.indexer.indexrequest.ClientIndexRequest;
import webdlpindexer.indexer.indexrequest.FilesystemIndexRequest;
import webdlpindexer.indexer.indexrequest.IndexRequest;

public class IndexerHandler
implements Runnable {
    private File indexDir;
    private File intellectualPropertyDir;
    private boolean newIndex;
    private boolean keepDelFiles;
    private boolean debug;
    private Indexer indexer;
    private BlockingQueue queue;

    public IndexerHandler(File indexDir, File intellectualPropertyDir, boolean newIndex, boolean keepDelFiles, boolean debug) {
        this.indexDir = indexDir;
        this.intellectualPropertyDir = intellectualPropertyDir;
        this.newIndex = newIndex;
        this.keepDelFiles = keepDelFiles;
        this.debug = debug;
        this.queue = new LinkedBlockingQueue();
    }

    @Override
    public void run() {
        if (!this.indexDir.exists()) {
            this.indexDir.mkdir();
        }
        this.indexer = new Indexer(this.indexDir, this.intellectualPropertyDir, this.keepDelFiles, this.debug);
        if (this.newIndex) {
            this.indexer.indexAll();
        }
        if (this.debug) {
            String message = "Now monitoring directory " + this.intellectualPropertyDir.getAbsolutePath() + " for changes.";
            System.out.println(message);
            Logger.log(message);
        }
        FileAlterationObserver observer = new FileAlterationObserver(this.intellectualPropertyDir);
        observer.addListener(new FileListener());
        long interval = 1000L;
        FileAlterationMonitor monitor = new FileAlterationMonitor(interval);
        monitor.addObserver(observer);
        try {
            monitor.start();
        }
        catch (Exception ex) {
            Logger.exception(ex);
            String error = "ERROR! Unable to monitor the intellectual property directory @ " + this.intellectualPropertyDir.toString() + "\n" + "System exiting...";
            Logger.error(error);
            System.out.println(error);
            System.exit(0);
        }
        boolean loop = true;
        while (loop) {
            block24: {
                try {
                    Enum requestType;
                    IndexRequest request = (IndexRequest)this.queue.take();
                    File file = request.getFile();
                    if (request.getClass() == ClientIndexRequest.class) {
                        ClientIndexRequest clientRequest = (ClientIndexRequest)request;
                        requestType = clientRequest.getRequestType();
                        try {
                            Socket clientSocket = clientRequest.getSocket();
                            ObjectOutputStream writer = new ObjectOutputStream(clientSocket.getOutputStream());
                            switch (1.$SwitchMap$webdlpindexer$indexer$indexrequest$ClientIndexRequest$RequestType[requestType.ordinal()]) {
                                case 1: {
                                    writer.writeObject(this.indexer.testSimilarity(file));
                                    break;
                                }
                                case 2: {
                                    writer.writeObject(this.indexer.testSimilarityWithThreshold(file, clientRequest.getThreshold()));
                                }
                            }
                            writer.flush();
                            writer.close();
                            clientSocket.close();
                            this.indexer.forceRemoveDocument(file);
                            if (!this.debug) {
                                request.getFile().delete();
                            }
                            if (this.debug) {
                                Logger.log(requestType.toString() + ": " + request.getFile().getName());
                            }
                            break block24;
                        }
                        catch (IOException ex) {
                            Logger.exception(ex);
                        }
                        break block24;
                    }
                    if (request.getClass() == FilesystemIndexRequest.class) {
                        FilesystemIndexRequest systemRequest = (FilesystemIndexRequest)request;
                        requestType = systemRequest.getRequestType();
                        switch (1.$SwitchMap$webdlpindexer$indexer$indexrequest$FilesystemIndexRequest$RequestType[requestType.ordinal()]) {
                            case 1: {
                                this.indexer.indexDocument(file);
                                break;
                            }
                            case 2: {
                                this.indexer.modifyDocument(file);
                                break;
                            }
                            case 3: {
                                this.indexer.removeDocument(file);
                            }
                        }
                        if (this.debug) {
                            Logger.log(requestType + ": " + file.getName());
                            Logger.log(this.indexer.getIndexInfo());
                        }
                    }
                }
                catch (InterruptedException ex) {
                    Logger.exception(ex);
                }
            }
            if (!this.debug) continue;
            Logger.log("Queuing " + this.queue.size() + " requests...");
        }
    }

    public void submitIndexRequest(IndexRequest request) {
        this.queue.add(request);
    }

    private class FileListener
    implements FileAlterationListener {
        private FileListener() {
        }

        @Override
        public void onStart(FileAlterationObserver fao) {
        }

        @Override
        public void onDirectoryCreate(File file) {
            throw new UnsupportedOperationException("onDirectoryCreate not supported yet.");
        }

        @Override
        public void onDirectoryChange(File file) {
            throw new UnsupportedOperationException("onDirectoryChange not supported yet.");
        }

        @Override
        public void onDirectoryDelete(File file) {
            throw new UnsupportedOperationException("onDirectoryDelete not supported yet.");
        }

        @Override
        public void onFileCreate(File file) {
            IndexerHandler.this.submitIndexRequest(new FilesystemIndexRequest(FilesystemIndexRequest.RequestType.ADD_FILE, file));
        }

        @Override
        public void onFileChange(File file) {
            IndexerHandler.this.submitIndexRequest(new FilesystemIndexRequest(FilesystemIndexRequest.RequestType.MODIFY_FILE, file));
        }

        @Override
        public void onFileDelete(File file) {
            IndexerHandler.this.submitIndexRequest(new FilesystemIndexRequest(FilesystemIndexRequest.RequestType.REMOVE_FILE, file));
        }

        @Override
        public void onStop(FileAlterationObserver fao) {
        }
    }
}

