#!/bin/bash

CONFIG=config.conf
source $CONFIG

# Perform input validation
if [ ! -e $IP_DIR ] ; then
	mkdir $IP_DIR
fi

if [ ! -e $INDEX ] ; then
	mkdir $INDEX
fi

if [ $NEW_INDEX != "true" ] && [ $NEW_INDEX != "false" ] ; then
	echo "Error in $CONFIG: $NEW_INDEX must equal either 'true' or 'false'. Defaulting to 1."
	NEW_INDEX=""
else 
	if [ $NEW_INDEX == "true" ] ; then
		NEW_INDEX="--createIndex"
	else
		NEW_INDEX=""
	fi
fi

if [ $KEEP_DEL_FILES != "true" ] && [ $KEEP_DEL_FILES != "false" ] ; then
	echo "Error in $CONFIG: KEEP_DEL_FILES must equal either 'true' or 'false'.  Defaulting to 1."
	KEEP_DEL_FILES=""
else
	if [ $KEEP_DEL_FILES == "true" ] ; then
                KEEP_DEL_FILES="--indexDeletedFiles"
        else
                KEEP_DEL_FILES=""
        fi
fi

if [ $DEBUG != "true" ] && [ $DEBUG != "false" ] ; then
	echo "Error in $CONFIG: DEBUG must equal either 'true' or 'false'.  Defaulting to false."
	DEBUG=""
else
	if [ $DEBUG == "true" ] ; then
                DEBUG="--debug"
        else
                DEBUG=""
        fi
fi
if [ $PORT -lt 0 ] || [ $PORT -gt  65535 ] ; then
	echo "Error in $CONFIG: PORT must be an integer between 0 and 65535. Defaulting to 22345."
	PORT=""
else
	PORT="--port "$PORT
fi

# Start the indexer
java -jar WebDLPIndexer.jar $INDEX $IP_DIR $NEW_INDEX $KEEP_DEL_FILES $DEBUG $PORT
