/**
 * Use of the WebDLPIndexer and related source code is subject to the
 * terms of the following license:
 *
 * Copyright (c) 2013 Carnegie Mellon University. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following acknowledgments and disclaimers.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. All advertising materials for third-party software mentioning features or
 * use of this software must display the following disclaimer:
 *
 * “Neither Carnegie Mellon University nor its Software Engineering Institute
 * have reviewed or endorsed this software”
 *
 * 4. The names “Carnegie Mellon University,” "CERT” and/or “Software
 * Engineering Institute" shall not be used to endorse or promote products
 * derived from this software without prior written permission. For written
 * permission, please contact permission@sei.cmu.edu.
 *
 * 5. Products derived from this software may not be called "CERT" nor may
 * "CERT" appear in their names without prior written permission of
 * permission@sei.cmu.edu.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 * acknowledgment:
 *
 * "This product includes software developed by CERT with funding and support
 * from the US Government under Contract No. FA8721-05-C-0003. The U.S.
 * Government's rights to use, modify, reproduce, release, perform, display, or
 * disclose this material are restricted by the Rights in Technical
 * Data-Noncommercial Items clauses (DFAR 252-227.7013 and DFAR 252-227.7013
 * Alternate I contained in the foregoing identified contract.
 *
 * THIS SOFTWARE IS PROVIDED BY CARNEGIE MELLON UNIVERSITY ``AS IS'' AND
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESS OR
 * IMPLIED, AS TO ANY MATTER, AND ALL SUCH WARRANTIES, INCLUDING WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, ARE EXPRESSLY
 * DISCLAIMED. WITHOUT LIMITING THE GENERALITY OF THE FOREGOING, CARNEGIE MELLON
 * UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND RELATING TO EXCLUSIVITY,
 * INFORMATIONAL CONTENT, ERROR-FREE OPERATION, RESULTS TO BE OBTAINED FROM USE,
 * FREEDOM FROM PATENT, TRADEMARK AND COPYRIGHT INFRINGEMENT AND/OR FREEDOM FROM
 * THEFT OF TRADE SECRETS.”
 *
 */
package webdlpindexer;

import java.io.*;
import java.net.Socket;
import java.util.UUID;
import webdlpindexer.indexer.IndexerHandler;
import webdlpindexer.indexer.indexrequest.ClientIndexRequest;
import webdlpindexer.indexer.indexrequest.ClientIndexRequest.RequestType;

/**
 * The class handles each client request in its own thread
 * 
 * @author Todd Lewellen
 */
public class ClientHandler implements Runnable{
   
    private Socket clientSocket;
    private IndexerHandler handler;    
    
    /**
     * 
     * @param h A reference to the IndexHandler object
     * @param socket The socket by which to communicate with the client
     */
    public ClientHandler(IndexerHandler h, Socket socket){
        clientSocket = socket; 
        handler = h;
    }

    @Override
    public void run() {
        try {                        
            ObjectInputStream input = new ObjectInputStream(clientSocket.getInputStream());
            
            //Read text data from the ICAP request and write it to a temporary file
            String data = input.readUTF();
            File f = new File("tmp" + System.getProperty("file.separator") + UUID.randomUUID().toString() + ".tmp");            
            f.createNewFile();
            BufferedWriter bf = new BufferedWriter(new FileWriter(f));
            bf.write(data);
            bf.flush();
            bf.close();
            
            //Read the threshold and determine the RequestType
            int threshold = input.readInt();            
            RequestType t;
            if(threshold >= 0 && threshold <= 100){
                t = RequestType.TEST_SIMILARITY_WITH_THRESHOLD;
            }
            else{
                t = RequestType.TEST_SIMILARITY;
            }
                     
            //Create a new ClientIndexRequest and add it to the IndexerHandler's queue
            ClientIndexRequest request = new ClientIndexRequest(t,f,threshold,clientSocket);
            handler.submitIndexRequest(request);
            
        } catch (IOException ex) {
            Logger.exception(ex);
        }
    }
}
