/**
 * Use of the WebDLPIndexer and related source code is subject to the
 * terms of the following license:
 *
 * Copyright (c) 2013 Carnegie Mellon University. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following acknowledgments and disclaimers.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. All advertising materials for third-party software mentioning features or
 * use of this software must display the following disclaimer:
 *
 * “Neither Carnegie Mellon University nor its Software Engineering Institute
 * have reviewed or endorsed this software”
 *
 * 4. The names “Carnegie Mellon University,” "CERT” and/or “Software
 * Engineering Institute" shall not be used to endorse or promote products
 * derived from this software without prior written permission. For written
 * permission, please contact permission@sei.cmu.edu.
 *
 * 5. Products derived from this software may not be called "CERT" nor may
 * "CERT" appear in their names without prior written permission of
 * permission@sei.cmu.edu.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 * acknowledgment:
 *
 * "This product includes software developed by CERT with funding and support
 * from the US Government under Contract No. FA8721-05-C-0003. The U.S.
 * Government's rights to use, modify, reproduce, release, perform, display, or
 * disclose this material are restricted by the Rights in Technical
 * Data-Noncommercial Items clauses (DFAR 252-227.7013 and DFAR 252-227.7013
 * Alternate I contained in the foregoing identified contract.
 *
 * THIS SOFTWARE IS PROVIDED BY CARNEGIE MELLON UNIVERSITY ``AS IS'' AND
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESS OR
 * IMPLIED, AS TO ANY MATTER, AND ALL SUCH WARRANTIES, INCLUDING WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, ARE EXPRESSLY
 * DISCLAIMED. WITHOUT LIMITING THE GENERALITY OF THE FOREGOING, CARNEGIE MELLON
 * UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND RELATING TO EXCLUSIVITY,
 * INFORMATIONAL CONTENT, ERROR-FREE OPERATION, RESULTS TO BE OBTAINED FROM USE,
 * FREEDOM FROM PATENT, TRADEMARK AND COPYRIGHT INFRINGEMENT AND/OR FREEDOM FROM
 * THEFT OF TRADE SECRETS.”
 *
 */
package webdlpindexer.indexer.indexrequest;

import java.io.File;
import java.net.Socket;

/**
 * This class is a simple structure to hold all of the information required to process
 * a request from a client.  It only allows the client to query the index at this time.
 * 
 * @author Todd Lewellen
 */
public class ClientIndexRequest extends IndexRequest{

    /**
     * Denotes the type of request being made by the client
     */
    public enum RequestType {

        /**
         * Mode by which the client can request to compare a single file against all of files in the index and get back the filenames and their percentage match score
         */
        TEST_SIMILARITY,
        /**
         * Mode by which the client can request to compare a single file against all of the files in the index and get back only the filenames and corresponding percentage match scores which exceed the input threshold
         */
        TEST_SIMILARITY_WITH_THRESHOLD,
    }
    
    private RequestType type;
    private int threshold;
    private Socket clientSocket;
    
    /**
     * @param t The type of query
     * @param f The file by which to compare against the index
     * @param thresh The threshold (between 0 and 100) by which to compare against
     * @param sock The socket used to communicate with the client
     */
    public ClientIndexRequest(RequestType t, File f, int thresh, Socket sock){
        super(f);
        type = t;
        threshold = thresh;
        clientSocket = sock;
    }
    
    /**
     * @param thresh The threshold (between 0 and 100) by which to compare against
     */
    public void setThreshold(int thresh){
        threshold = thresh;
    }
    
    /**
     * @return The type of query request
     */
    public RequestType getRequestType() {
        return type;
    }
    
    /**
     * @return The threshold (between 0 and 100) by which to compare against
     */
    public int getThreshold(){
        return threshold;
    }
    
    /**
     * @return The socket used to communicate with the client
     */
    public Socket getSocket(){
        return clientSocket;
    }
}
