# ARP4761 Example

This example reproduces the Wheel Brake System described
in the ARP4761 and AIR6110 standards. It was originally
designed by the Software Engineering Institute (SEI) at
Carnegie Mellon University (CMU) to demonstrate the following
capabilities of OSATE:
* Fault Hazard Assesment
* Fault Impact (FMEA/FMES)
* Fault Tree Analysis

A complete description of the case-study is available in [AADL Fault Modeling and Analysis Within an ARP4761 Safety Assessment (CMU/SEI-2014-TR-020)](https://resources.sei.cmu.edu/asset_files/TechnicalReport/2014_005_001_311911.pdf)

The TR is based upon an earlier version of OSATE. This README is based on OSATE 2.7.1.

### Organization of the example

There are two models contained within this project. The one used for much of the TR is *simple* (wbs.aadl is the main AADL module) -- other features are illustrated in *advanced* (wbs.aadl in the *implementation* folder is the main AADL module).

### Creating a diagram

To generate the diagram shown in Figure 26 of TR, open [simple->wbs.aadl](./simple/wbs.aadl), right click on one of the implementations in the Outline perspective and select "Create Diagram...". The resulting diagram will be somewhat different in appearance to the one in the figure due to the newer version of OSATE.

### Conducting analysis

To analyze the model start by right clicking on one of the implementations in the Outline perspective and select "Instantiate". The instantiation is placed in the instance folder within the model in the AADL Navigator. Click the instantiation (e.g., wbs_wbs_ima_instance.aaxl2) and then select the desired analysis (e.g., from the Analyses menu).

![png](./doc/analyses-menu.png)

Note that due to differences in the various analysis engines and/or the graphics display the outputs will not match the TR exactly. For example, running the Fault Tree Analysis (Analyses->Safety->Run Fault Tree Analysis) will produce a fault tree that looks significantly different from that shown in the TR.

### The advanced model

The diagram in Figure 32 of the TR is generated by opening main.aadl in the "functional" folder and selecting *system implementation Aircraft.basic*. If this implementation is instanciated running a Fault Impact Analysis produces an output identical to that in Figure 36 of the TR.

When the TR talks about the "realization model" it means the model found in the implementation folder. The binding associations are in the integration folder.

### TODO

* Add bus bindings with error propagation within the platform elements

5/7/2020

