package org.osate.slicer.evaluation;

import java.time.Duration;
import java.util.concurrent.TimeUnit;

public record PerformanceData(String name, int slicerVertices, int slicerEdges, Duration instantiationTime,
		Duration genRun1,
		Duration genRun2, Duration genRun3, Duration forwardReach1Time, Duration forwardReach2Time,
		Duration forwardReach3Time, Duration backwardReach1Time, Duration backwardReach2Time,
		Duration backwardReach3Time, Duration reachFrom1Time, Duration reachFrom2Time, Duration reachFrom3Time,
		Duration reachThrough1Time, Duration reachThrough2Time, Duration reachThrough3Time) {

	public String toCSV() {
		StringBuilder sb = new StringBuilder(120);

		sb.append(name);
		sb.append(":\t");

		sb.append(slicerVertices);
		sb.append("\t");
		sb.append(slicerEdges);
		sb.append("\t");

		sb.append(TimeUnit.MICROSECONDS.convert(instantiationTime));
		sb.append("\t");
		sb.append(TimeUnit.MICROSECONDS.convert(genRun1));
		sb.append("\t");
		sb.append(TimeUnit.MICROSECONDS.convert(genRun2));
		sb.append("\t");
		sb.append(TimeUnit.MICROSECONDS.convert(genRun3));
		sb.append("\t");
		sb.append((TimeUnit.MICROSECONDS.convert(genRun1) + TimeUnit.MICROSECONDS.convert(genRun2)
				+ TimeUnit.MICROSECONDS.convert(genRun3)) / 3);
		sb.append("\t");

		sb.append(TimeUnit.MICROSECONDS.convert(forwardReach1Time));
		sb.append("\t");
		sb.append(TimeUnit.MICROSECONDS.convert(forwardReach2Time));
		sb.append("\t");
		sb.append(TimeUnit.MICROSECONDS.convert(forwardReach3Time));
		sb.append("\t");
		sb.append((TimeUnit.MICROSECONDS.convert(forwardReach1Time) + TimeUnit.MICROSECONDS.convert(forwardReach2Time)
				+ TimeUnit.MICROSECONDS.convert(forwardReach3Time)) / 3);
		sb.append("\t");

//		sb.append(TimeUnit.MICROSECONDS.convert(backwardReach1Time));
//		sb.append("\t");
//		sb.append(TimeUnit.MICROSECONDS.convert(backwardReach2Time));
//		sb.append("\t");
//		sb.append(TimeUnit.MICROSECONDS.convert(backwardReach3Time));
//		sb.append("\t");
//		sb.append((TimeUnit.MICROSECONDS.convert(backwardReach1Time) + TimeUnit.MICROSECONDS.convert(backwardReach2Time)
//				+ TimeUnit.MICROSECONDS.convert(backwardReach3Time)) / 3);
//		sb.append("\t");

		sb.append(TimeUnit.MICROSECONDS.convert(reachFrom1Time));
		sb.append("\t");
		sb.append(TimeUnit.MICROSECONDS.convert(reachFrom2Time));
		sb.append("\t");
		sb.append(TimeUnit.MICROSECONDS.convert(reachFrom3Time));
		sb.append("\t");
		sb.append((TimeUnit.MICROSECONDS.convert(reachFrom1Time) + TimeUnit.MICROSECONDS.convert(reachFrom2Time)
				+ TimeUnit.MICROSECONDS.convert(reachFrom3Time)) / 3);
		sb.append("\t");

		sb.append(TimeUnit.MICROSECONDS.convert(reachThrough1Time));
		sb.append("\t");
		sb.append(TimeUnit.MICROSECONDS.convert(reachThrough2Time));
		sb.append("\t");
		sb.append(TimeUnit.MICROSECONDS.convert(reachThrough3Time));
		sb.append("\t");
		sb.append((TimeUnit.MICROSECONDS.convert(reachThrough1Time) + TimeUnit.MICROSECONDS.convert(reachThrough2Time)
				+ TimeUnit.MICROSECONDS.convert(reachThrough3Time)) / 3);
		return sb.toString();
	}
}
